<!-- ============================ Page Title Start================================== -->
<div class="image-cover page-title">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <h1 class="ipt-title"><?php echo e(__('Agent Detail')); ?></h1>
                <span class="ipn-subtitle"><?php echo e($account->name); ?></span>
            </div>
        </div>
    </div>
</div>
<!-- ============================ Page Title End ================================== -->

<!-- ============================ Agency Name Start================================== -->
<section class="agent-page p-0 gray-simple">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="agency agency-list overlio-40">

                    <div class="agency-avatar">
                        <?php if($account->avatar->url): ?>
                            <img src="<?php echo e(RvMedia::getImageUrl($account->avatar->url, 'thumb')); ?>"
                                alt="<?php echo e($account->name); ?>" class="img-thumbnail">
                        <?php else: ?>
                            <img src="<?php echo e($account->avatar_url); ?>" alt="<?php echo e($account->name); ?>" class="img-thumbnail">
                        <?php endif; ?>
                    </div>

                    <div class="agency-content">
                        <div class="agency-name">
                            <h4><a href="#"><?php echo e($account->name); ?></a></h4>
                            <span><i class="lni-phone-handset"></i><?php echo e($account->phone); ?></span>
                        </div>

                        <div class="agency-desc">
                            <p><?php echo e($account->description); ?></p>
                        </div>

                        <div class="prt-detio">
                            <span><?php echo e($totalProperties); ?> <?php echo e(__('Property')); ?></span>
                        </div>

                        <div class="clearfix"></div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

<!-- ============================ About Agency ================================== -->
<section class="min gray-simple">
    <div class="container">
        <div class="row">
            <!-- property main detail -->
            <div class="col-lg-12 col-md-12 col-sm-12">
                <!-- Single Block Wrap -->
                <div class="block-wrap">

                    <div class="block-header">
                        <h4 class="block-title"><?php echo e(__('Agent info')); ?></h4>
                    </div>

                    <div class="block-body">
                        <ul class="dw-proprty-info">
                            <li><strong><?php echo e(__('Ceo')); ?></strong><?php echo e($account->name); ?></li>
                            <li><strong><?php echo e(__('Email')); ?></strong><?php echo e($account->email); ?></li>
                            <li><strong><?php echo e(__('Phone')); ?></strong><?php echo e($account->phone); ?></li>
                            <li><strong><?php echo e(__('Joined on')); ?></strong> <?php echo e($account->created_at->toDateString()); ?>

                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Single Block Wrap -->
                <div class="block-wraps">
                    <div class="block-wraps-header">
                        <div class="block-header">
                            <ul class="nav nav-tabs customize-tab" id="myTab" role="tablist">
                                <?php $__currentLoopData = $propertiesRelated; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $propertiesRelatedItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link <?php if($loop->first): ?> active <?php endif; ?>"
                                            id="tab-type-<?php echo e($propertiesRelatedItem['type']->id); ?>"
                                            data-bs-toggle="tab"
                                            href="#tab-content-type-<?php echo e($propertiesRelatedItem['type']->id); ?>"
                                            role="tab"
                                            aria-selected="true"><?php echo e($propertiesRelatedItem['type']->name); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>

                        <div class="block-body">
                            <div class="tab-content" id="myTabContent">
                                <?php $__currentLoopData = $propertiesRelated; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $propertiesRelatedItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="tab-pane fade show <?php if($loop->first): ?> active <?php endif; ?>" role="tabpanel"
                                        id="tab-content-type-<?php echo e($propertiesRelatedItem['type']->id); ?>"
                                        aria-labelledby="tab-type-<?php echo e($propertiesRelatedItem['type']->id); ?>">
                                        <!-- row -->
                                        <?php if($propertiesRelatedItem['properties']->count()): ?>
                                            <div class="row">
                                                <?php $__currentLoopData = $propertiesRelatedItem['properties']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-lg-4 col-md-6 col-sm-12">
                                                        <?php echo Theme::partial('real-estate.properties.item-grid', ['property' => $property, 'img_slider' => false]); ?>

                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>

                                            <div class="row">
                                                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                                                    <nav class="d-flex justify-content-center pt-3">
                                                        <?php echo $propertiesRelatedItem['properties']->withQueryString()->links(); ?>

                                                    </nav>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <div class="row">
                                                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                                                    <p class="item"><?php echo e(__('0 results')); ?></p>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/technoso/public_html/sukna.eazisols.com/platform/themes/resido/views/real-estate/agent.blade.php ENDPATH**/ ?>