
<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1 class="text-center" style="padding-top: 20px;"><?php echo e(trans('core/base::system.updater')); ?></h1><br>
        <div class="updater-box" dir="ltr">
            <div class="note note-warning">
                <p>- Please backup your database and script files before upgrading.</p>
                <p>- You need to activate your license before doing upgrade.</p>
                <p>- If you don't need this 1-click update, you can disable it in <strong>.env</strong> by adding <strong>CMS_ENABLE_SYSTEM_UPDATER=false</strong></p>
                <p>- It will override all files in <strong>platform/core</strong>, <strong>platform/packages</strong>, all plugins developed by us in <strong>platform/plugins</strong> and theme developed by us in <strong>platform/themes</strong>.</p>
            </div>
            <p class="mb-0 text-success">
                <?php echo e($updateData['message']); ?>

            </p>
            <div class="content">
                <?php if($updateData['status']): ?>
                    <br>
                    <div class="note note-info changelog-info">
                        <?php echo trim($updateData['changelog']); ?>

                    </div>
                    <br>
                    <?php if(request()->input('update_id')): ?>
                        <?php
                            $updateId = strip_tags(trim(request()->input('update_id')));
                            $version = strip_tags(trim(request()->input('version')));
                            echo '<progress id="prog" value="0" max="100.0" class="progress is-success" style="margin-bottom: 10px;"></progress>';
                            $api->downloadUpdate($updateId, $version);
                        ?>
                    <?php else: ?>
                        <form action="<?php echo e(route('system.updater')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" class="form-control" value="<?php echo e($updateData['update_id']); ?>" name="update_id">
                            <input type="hidden" class="form-control" value="<?php echo e($updateData['version']); ?>" name="version">
                            <p class="text-center">
                                <button type="submit" class="btn btn-warning btn-update-new-version" data-updating-text="Updating..."><i class="fa fa-download"></i> <span>Download & Install Update</span></button>
                            </p>
                        </form>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(BaseHelper::getAdminMasterLayoutTemplate(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/technoso/public_html/sukna.eazisols.com/platform/core/base/resources/views//system/updater.blade.php ENDPATH**/ ?>