
<?php
$user = auth('account')->user();
?>
<?php $__env->startSection('content'); ?>
    <div class="dashboard-wraper settings crop-avatar">
        <!-- Basic Information -->
        <div class="form-submit">
            <!-- Setting Title -->
            <div class="row">
                <div class="col-12">
                    <h4 class="with-actions"><?php echo e(trans('plugins/real-estate::dashboard.account_field_title')); ?></h4>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-8 order-lg-0">
                    <?php if(session('status')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('status')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>
                    <form action="<?php echo e(route('public.account.post.settings')); ?>" id="setting-form" method="POST">
                    <?php echo csrf_field(); ?>
                    <!-- Name -->
                        <div class="form-group">
                            <label for="first_name"><?php echo e(trans('plugins/real-estate::dashboard.first_name')); ?></label>
                            <input type="text" class="form-control" name="first_name" id="first_name" required
                                   value="<?php echo e(old('first_name') ?? $user->first_name); ?>">
                        </div>
                        <!-- Name -->
                        <div class="form-group">
                            <label for="last_name"><?php echo e(trans('plugins/real-estate::dashboard.last_name')); ?></label>
                            <input type="text" class="form-control" name="last_name" id="last_name" required
                                   value="<?php echo e(old('last_name') ?? $user->last_name); ?>">
                        </div>
                        <div class="form-group">
                            <label for="username"><?php echo e(trans('plugins/real-estate::dashboard.username')); ?></label>
                            <input type="text" class="form-control" name="username" id="username" required
                                   value="<?php echo e(old('username') ?? $user->username); ?>">
                        </div>
                        <!-- Phone -->
                        <div class="form-group">
                            <label for="phone"><?php echo e(trans('plugins/real-estate::dashboard.phone')); ?></label>
                            <input type="text" class="form-control" name="phone" id="phone" required
                                   value="<?php echo e(old('phone') ?? $user->phone); ?>">
                        </div>
                        <!--Short description-->
                        <div class="form-group">
                            <label
                                for="description"><?php echo e(trans('plugins/real-estate::dashboard.description')); ?></label>
                            <textarea class="form-control" name="description" id="description" rows="3"
                                      maxlength="300"
                                      placeholder="<?php echo e(trans('plugins/real-estate::dashboard.description_placeholder')); ?>"><?php echo e(old('description') ?? $user->description); ?></textarea>
                        </div>
                        <!-- Email -->
                        <div class="form-group">
                            <label for="email"><?php echo e(trans('plugins/real-estate::dashboard.email')); ?></label>
                            <input type="email" class="form-control" name="email" id="email" disabled="disabled"
                                   placeholder="<?php echo e(trans('plugins/real-estate::dashboard.email_placeholder')); ?>"
                                   required
                                   value="<?php echo e(old('email') ?? $user->email); ?>">
                            <?php if($user->confirmed_at): ?>
                                <small class="f7 green"><?php echo e(trans('plugins/real-estate::dashboard.verified')); ?><i
                                        class="ml1 far fa-check-circle"></i></small>
                            <?php else: ?>
                                <small class="f7"><?php echo e(trans('plugins/real-estate::dashboard.verify_require_desc')); ?>

                                    <a
                                        href="<?php echo e(route('public.account.resend_confirmation', ['email' => $user->email])); ?>"
                                        class="ml1"><?php echo e(trans('plugins/real-estate::dashboard.resend')); ?></a></small>
                            <?php endif; ?>
                        </div>

                        <!-- Birthday -->
                        <div class="form-group">
                            <label for="dob"><?php echo e(trans('plugins/real-estate::dashboard.birthday')); ?></label>
                            <div class="birthday-box">
                                <select id="year" name="year"
                                        class="form-control<?php echo e($errors->has('year') ? ' is-invalid' : ''); ?>"
                                        style="width: 74px!important; display: inline-block!important;"
                                        onchange="changeYear(this)"></select>
                                <select id="month" name="month"
                                        class="form-control<?php echo e($errors->has('month') ? ' is-invalid' : ''); ?>"
                                        style="width: 90px!important; display: inline-block!important;"
                                        onchange="changeMonth(this)"></select>
                                <select id="day" name="day"
                                        class="form-control<?php echo e($errors->has('day') ? ' is-invalid' : ''); ?>"
                                        style="width: 74px!important; display: inline-block!important;"></select>
                                <span class="invalid-feedback">
                                <strong><?php echo e($errors->has('dob') ? $errors->first('dob') : ''); ?></strong>
                            </span>
                            </div>
                        </div>

                        <!-- Gender -->
                        <div class="form-group">
                            <label for="gender"><?php echo e(trans('plugins/real-estate::dashboard.gender')); ?></label>
                            <select class="form-control" name="gender" id="gender">
                                <option
                                    value="male" <?php echo e($user->gender == 'male' ? 'selected' : ''); ?>><?php echo e(trans('plugins/real-estate::dashboard.gender_male')); ?></option>
                                <option
                                    value="female" <?php echo e($user->gender == 'female' ? 'selected' : ''); ?>><?php echo e(trans('plugins/real-estate::dashboard.gender_female')); ?></option>
                                <option
                                    value="other" <?php echo e($user->gender == 'other' ? 'selected' : ''); ?>><?php echo e(trans('plugins/real-estate::dashboard.gender_other')); ?></option>
                            </select>
                        </div>

                        <button type="submit"
                                class="btn btn-primary fw6"><?php echo e(trans('plugins/real-estate::dashboard.save')); ?></button>
                    </form>
                </div>
                <div class="col-lg-4 order-lg-12">
                    <form id="avatar-upload-form" enctype="multipart/form-data" action="javascript:void(0)"
                          onsubmit="return false">
                        <div class="avatar-upload-container">
                            <div class="form-group">
                                <label
                                    for="account-avatar"><?php echo e(trans('plugins/real-estate::dashboard.profile-picture')); ?></label>
                                <div id="account-avatar">
                                    <div class="profile-image">
                                        <div class="avatar-view mt-card-avatar">
                                            <img class="br2" src="<?php echo e($user->avatar_url); ?>" style="width: 200px;">
                                            <div class="mt-overlay br2">
                                                <span><i class="fa fa-edit"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Print messages -->
                            <div id="print-msg" class="alert dn"></div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <?php echo $__env->make(Theme::getThemeNamespace() . '::views.real-estate.account.modals.avatar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <!-- Laravel Javascript Validation -->
    <script type="text/javascript" src="<?php echo e(asset('vendor/core/core/js-validation/js/js-validation.js')); ?>"></script>
    <?php echo JsValidator::formRequest(\Botble\RealEstate\Http\Requests\SettingRequest::class); ?>

    <script type="text/javascript">
        "use strict";
        let numberDaysInMonth = [31,28,31,30,31,30,31,31,30,31,30,31];

        $(document).ready(function() {
            initSelectBox();
        });

        function initSelectBox() {
            let oldBirthday = '<?php echo e($user->dob); ?>';
            let selectedDay = '';
            let selectedMonth = '';
            let selectedYear = '';

            if (oldBirthday !== '') {
                selectedDay = parseInt(oldBirthday.substr(8, 2));
                selectedMonth = parseInt(oldBirthday.substr(5, 2));
                selectedYear = parseInt(oldBirthday.substr(0, 4));
            }

            let dayOption = `<option value=""><?php echo e(trans('plugins/real-estate::dashboard.day_lc')); ?></option>`;
            for (let i = 1; i <= numberDaysInMonth[0]; i++) { //add option days
                if (i === selectedDay) {
                    dayOption += `<option value="${i}" selected>${i}</option>`;
                } else {
                    dayOption += `<option value="${i}">${i}</option>`;
                }
            }
            $('#day').append(dayOption);

            let monthOption = `<option value=""><?php echo e(trans('plugins/real-estate::dashboard.month_lc')); ?></option>`;
            for (let j = 1; j <= 12; j++) {
                if (j === selectedMonth) {
                    monthOption += `<option value="${j}" selected>${j}</option>`;
                } else {
                    monthOption += `<option value="${j}">${j}</option>`;
                }
            }
            $('#month').append(monthOption);

            let d = new Date();
            let yearOption = `<option value=""><?php echo e(trans('plugins/real-estate::dashboard.year_lc')); ?></option>`;
            for (let k = d.getFullYear(); k >= 1918; k--) {// years start k
                if (k === selectedYear) {
                    yearOption += `<option value="${k}" selected>${k}</option>`;
                } else {
                    yearOption += `<option value="${k}">${k}</option>`;
                }
            }
            $('#year').append(yearOption);
        }

        function isLeapYear(year) {
            year = parseInt(year);
            if (year % 4 !== 0) {
                return false;
            }
            if (year % 400 === 0) {
                return true;
            }
            if (year % 100 === 0) {
                return false;
            }
            return true;
        }

        function changeYear(select) {
            if (isLeapYear($(select).val())) {
                // Update day in month of leap year.
                numberDaysInMonth[1] = 29;
            } else {
                numberDaysInMonth[1] = 28;
            }

            // Update day of leap year.
            let monthSelectedValue = parseInt($("#month").val());
            if (monthSelectedValue === 2) {
                let day = $('#day');
                let daySelectedValue = parseInt($(day).val());
                if (daySelectedValue > numberDaysInMonth[1]) {
                    daySelectedValue = null;
                }

                $(day).empty();

                let option = `<option value=""><?php echo e(trans('plugins/real-estate::dashboard.day_lc')); ?></option>`;
                for (let i = 1; i <= numberDaysInMonth[1]; i++) { //add option days
                    if (i === daySelectedValue) {
                        option += `<option value="${i}" selected>${i}</option>`;
                    } else {
                        option += `<option value="${i}">${i}</option>`;
                    }
                }

                $(day).append(option);
            }
        }

        function changeMonth(select) {
            let day = $('#day');
            let daySelectedValue = parseInt($(day).val());
            let month = 0;

            if ($(select).val() !== '') {
                month = parseInt($(select).val()) - 1;
            }

            if (daySelectedValue > numberDaysInMonth[month]) {
                daySelectedValue = null;
            }

            $(day).empty();

            let option = `<option value=""><?php echo e(trans('plugins/real-estate::dashboard.day_lc')); ?></option>`;

            for (let i = 1; i <= numberDaysInMonth[month]; i++) { //add option days
                if (i === daySelectedValue) {
                    option += `<option value="${i}" selected>${i}</option>`;
                } else {
                    option += `<option value="${i}">${i}</option>`;
                }
            }

            $(day).append(option);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(Theme::getThemeNamespace() . '::views.real-estate.account.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/technoso/public_html/sukna.eazisols.com/platform/themes/resido/views/real-estate/account/settings/index.blade.php ENDPATH**/ ?>