<div id="credit-histories">
    <br>
    <h4><?php echo e(__('Credits')); ?>: <?php echo e($account->credits); ?></h4>

    <div class="mt20 mb20">
        <div>
            <div class="comment-log ws-nm">
                <div class="comment-log-title">
                    <div class="row">
                        <div class="col-md-6">
                            <label class="bold-light m-xs-b hide-print"><?php echo e(__('Transactions')); ?></label>
                        </div>
                        <div class="col-md-6 text-end">
                            <a href="#" class="btn-trigger-add-credit"><?php echo e(__('Manual Transaction')); ?></a>
                        </div>
                    </div>
                </div>
                <div class="comment-log-timeline">
                    <?php if($transactions->count() > 0): ?>
                        <div class="column-left-history ps-relative" id="order-history-wrapper">
                            <div class="item-card">
                                <div class="item-card-body clearfix">
                                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="item comment-log-item comment-log-item-date ui-feed__timeline">
                                            <div class="ui-feed__item ui-feed__item--message">
                                                <span class="ui-feed__marker <?php if($transaction->account_id): ?> ui-feed__marker--user-action <?php endif; ?>"></span>
                                                <div class="ui-feed__message">
                                                    <div class="timeline__message-container">
                                                        <div class="timeline__inner-message">
                                                            <a href="#"
                                                               class="text-no-bold show-timeline-dropdown hover-underline"
                                                               data-target="#history-line-<?php echo e($transaction->id); ?>">
                                                                <?php echo clean($transaction->getDescription()); ?>

                                                            </a>
                                                        </div>
                                                        <time class="timeline__time">
                                                            <span><?php echo e($transaction->created_at); ?></span></time>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="timeline-dropdown" id="history-line-<?php echo e($transaction->id); ?>">
                                                <?php echo e($transaction->description); ?>

                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <p><?php echo e(__('No transactions!')); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/technoso/public_html/sukna.eazisols.com/platform/plugins/real-estate/resources/views//account/admin/credits.blade.php ENDPATH**/ ?>