<link rel="stylesheet" href="<?php echo e(asset('vendor/core/plugins/payment/css/payment.css')); ?>?v=1.0.4">
<script src="<?php echo e(asset('vendor/core/plugins/payment/js/payment.js')); ?>?v=1.0.4"></script>

<?php echo apply_filters(PAYMENT_FILTER_HEADER_ASSETS, null); ?>


<div class="checkout-wrapper">
    <div>
        <form action="<?php echo e($action); ?>" method="post" class="payment-checkout-form">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="name" value="<?php echo e($name); ?>">
            <input type="hidden" name="amount" value="<?php echo e($amount); ?>">
            <input type="hidden" name="currency" value="<?php echo e($currency); ?>">
            <?php if(isset($returnUrl)): ?>
                <input type="hidden" name="return_url" value="<?php echo e($returnUrl); ?>">
            <?php endif; ?>
            <?php if(isset($callbackUrl)): ?>
                <input type="hidden" name="callback_url" value="<?php echo e($callbackUrl); ?>">
            <?php endif; ?>
            <?php echo apply_filters(PAYMENT_FILTER_PAYMENT_PARAMETERS, null); ?>

            <ul class="list-group list_payment_method">

                <?php echo apply_filters(PAYMENT_FILTER_ADDITIONAL_PAYMENT_METHODS, null, compact('name', 'amount', 'currency')); ?>


                <?php if(setting('payment_cod_status') == 1): ?>
                    <li class="list-group-item">
                        <input class="magic-radio js_payment_method" type="radio" name="payment_method" id="payment_cod"
                               <?php if((session('selected_payment_method') ?: setting('default_payment_method')) == \Botble\Payment\Enums\PaymentMethodEnum::COD): ?> checked <?php endif; ?>
                               value="cod" data-bs-toggle="collapse" data-bs-target=".payment_cod_wrap" data-toggle="collapse" data-target=".payment_cod_wrap" data-parent=".list_payment_method">
                        <label for="payment_cod" class="text-start"><?php echo e(setting('payment_cod_name', trans('plugins/payment::payment.payment_via_cod'))); ?></label>
                        <div class="payment_cod_wrap payment_collapse_wrap collapse <?php if((session('selected_payment_method') ?: setting('default_payment_method')) == \Botble\Payment\Enums\PaymentMethodEnum::COD): ?> show <?php endif; ?>" style="padding: 15px 0;">
                            <p><?php echo BaseHelper::clean(setting('payment_cod_description')); ?></p>
                        </div>
                    </li>
                <?php endif; ?>

                <?php if(setting('payment_bank_transfer_status') == 1): ?>
                    <li class="list-group-item">
                        <input class="magic-radio js_payment_method" type="radio" name="payment_method" id="payment_bank_transfer"
                               <?php if((session('selected_payment_method') ?: setting('default_payment_method')) == \Botble\Payment\Enums\PaymentMethodEnum::BANK_TRANSFER): ?> checked <?php endif; ?>
                               value="bank_transfer" data-bs-toggle="collapse" data-bs-target=".payment_bank_transfer_wrap" data-toggle="collapse" data-target=".payment_bank_transfer_wrap" data-parent=".list_payment_method">
                        <label for="payment_bank_transfer" class="text-start"><?php echo e(setting('payment_bank_transfer_name', trans('plugins/payment::payment.payment_via_bank_transfer'))); ?></label>
                        <div class="payment_bank_transfer_wrap payment_collapse_wrap collapse <?php if((session('selected_payment_method') ?: setting('default_payment_method')) == \Botble\Payment\Enums\PaymentMethodEnum::BANK_TRANSFER): ?> show <?php endif; ?>" style="padding: 15px 0;">
                            <p><?php echo BaseHelper::clean(setting('payment_bank_transfer_description')); ?></p>
                        </div>
                    </li>
                <?php endif; ?>
            </ul>

            <br>
            <div class="text-center">
                <button class="payment-checkout-btn btn btn-info" data-processing-text="<?php echo e(__('Processing. Please wait...')); ?>" data-error-header="<?php echo e(__('Error')); ?>"><?php echo e(__('Checkout')); ?></button>
            </div>
        </form>
    </div>
</div>

<?php echo apply_filters(PAYMENT_FILTER_FOOTER_ASSETS, null); ?>

<?php /**PATH /home/technoso/public_html/sukna.eazisols.com/platform/plugins/payment/resources/views//partials/form.blade.php ENDPATH**/ ?>