<?php if($property->reviews_count > 0): ?>
    <real-estate-reviews-component api-get-reviews="<?php echo e(route('public.ajax.real-estate-reviews', $property->id)); ?>" 
        api-get-rating="<?php echo e(route('public.ajax.real-estate-rating', $property->id)); ?>" :review-fields="<?php echo e(json_encode(get_review_fields())); ?>">
    </real-estate-reviews-component>
<?php endif; ?>
    
<?php if(!auth('account')->check() || !check_if_reviewed($property->id)): ?>
<div class="property_block_wrap style-2">

    <div class="property_block_wrap_header">
        <a data-bs-toggle="collapse" data-parent="#comment" data-bs-target="#clTen" aria-controls="clTen"
            href="javascript:void(0);" aria-expanded="true">
            <h4 class="property_block_title"><?php echo e(__('Write a Review')); ?></h4>
            
        </a>
        <?php if(!auth('account')->check()): ?>
            <p class="text-danger"><?php echo e(__('Please')); ?> <a class="text-danger" href="<?php echo e(route('public.account.login')); ?>"><?php echo e(__('login')); ?></a> <?php echo e(__('to write review!')); ?></p>
        <?php endif; ?>
    </div>

    <div id="clTen" class="panel-collapse collapse show">
        <div class="block-body">
            <?php echo Form::open(['route' => 'public.reviews.create', 'method' => 'post', 'class' => 'form--review-product']); ?>

            <input type="hidden" name="reviewable_id" value="<?php echo e($property->id); ?>">
            <input type="hidden" name="reviewable_type" value="<?php echo e(get_class($property)); ?>">
            <div class="row py-3">
                <div class="col-md-8">
                    <div class="row">
                        <?php $__currentLoopData = get_review_fields(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-6 col-md-6 col-sm-12">
                            <label for="select-star"><?php echo e(trans('plugins/real-estate::review.'.$item['field'])); ?></label>
                            <select class="rating" name="meta[<?php echo e($item['field']); ?>]" id="select-star-<?php echo e($item['field']); ?>" data-read-only="false" <?php if(!auth('account')->check()): ?> disabled <?php endif; ?>>
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="3">3</option>
                                <option value="4">4</option>
                                <option value="5" selected>5</option>
                            </select>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-12">
                    <div class="avg-total-pilx">
                        <input type="hidden" name="star" value="5">
                        <h4 class="high user_commnet_avg_rate">5</h4>
                        <span><?php echo e(__('Average Rating')); ?></span>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="form-group">
                        <textarea name="comment" class="form-control ht-80" placeholder="<?php echo e(__('Messages')); ?>" <?php if(!auth('account')->check()): ?> disabled <?php endif; ?>></textarea>
                    </div>
                </div>

                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="form-group">
                        <button class="btn btn-theme-light-2 rounded" type="submit" <?php if(!auth('account')->check()): ?> disabled <?php endif; ?>><?php echo e(__('Submit Review')); ?></button>
                    </div>
                </div>

            </div>
            <?php echo Form::close(); ?>

        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\sukna\platform/themes/resido/partials/real-estate/elements/review.blade.php ENDPATH**/ ?>