<?php
    $is_lazyload = isset($lazyload) ? $lazyload : true;
?>
<div class="property-listing property-1" data-lat="<?php echo e($property->latitude); ?>"
     data-long="<?php echo e($property->longitude); ?>">
    <div class="listing-img-wrapper">
        <a href="<?php echo e($property->url); ?>">
            <?php if($is_lazyload): ?>
                <img src="<?php echo e(get_image_loading()); ?>"
                     data-src="<?php echo e(RvMedia::getImageUrl($property->image ?? '', 'medium', false, RvMedia::getDefaultImage())); ?>"
                     class="img-fluid mx-auto lazy" alt="<?php echo e($property->name); ?>"/>
            <?php else: ?>
                <img
                    src="<?php echo e(RvMedia::getImageUrl($property->image ?? '', 'medium', false, RvMedia::getDefaultImage())); ?>"
                    class="img-fluid mx-auto" alt="<?php echo e($property->name); ?>"/>
            <?php endif; ?>
        </a>
        <div class="icon-actions-wrapper">
            <a href="JavaScript:Void(0);" data-id="<?php echo e($property->id); ?>" class="add-to-wishlist">
                <i class="far fa-heart"></i>
            </a>
        </div>
    </div>

    <div class="listing-content">

        <div class="listing-detail-wrapper-box">
            <div class="listing-detail-wrapper">
                <div class="listing-short-detail">
                    <h4 class="listing-name">
                        <a href="<?php echo e($property->url); ?>" title="<?php echo e($property->name); ?>"><?php echo clean($property->name); ?></a>
                    </h4>
                </div>
                <div class="list-price">
                    <div>
                        <?php if(is_review_enabled() && $property->reviews_count > 0): ?>
                            <?php echo Theme::partial('real-estate.elements.property-review', compact('property')); ?>

                        <?php endif; ?>
                        <span class="prt-types <?php echo e($property->type->slug); ?>"><?php echo e($property->type_name); ?></span>
                        <?php if($property->label): ?>
                            <span class="prt-types rent"><?php echo e($property->label); ?></span>
                        <?php endif; ?>
                    </div>
                    <h6 class="listing-card-info-price"> <?php echo e($property->price_html); ?> </h6>
                </div>
            </div>
        </div>

        <div class="price-features-wrapper">
            <div class="list-fx-features">
                <?php if($property->number_bedroom): ?>
                    <div class="listing-card-info-icon">
                        <div class="inc-fleat-icon">
                            <img src="<?php echo e(Theme::asset()->url('img/bed.svg')); ?>" width="13" alt=""/>
                        </div>
                        <?php echo clean($property->number_bedroom); ?> <?php echo __('Beds'); ?>

                    </div>
                <?php endif; ?>

                <?php if($property->number_bathroom): ?>
                    <div class="listing-card-info-icon">
                        <div class="inc-fleat-icon">
                            <img src="<?php echo e(Theme::asset()->url('img/bathtub.svg')); ?>" width="13" alt=""/>
                        </div>
                        <?php echo clean($property->number_bathroom); ?> <?php echo __('Bath'); ?>

                    </div>
                <?php endif; ?>

                <?php if($property->square_text): ?>
                    <div class="listing-card-info-icon">
                        <div class="inc-fleat-icon">
                            <img src="<?php echo e(Theme::asset()->url('img/move.svg')); ?>" width="13" alt=""/>
                        </div>
                        <?php echo e($property->square_text); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="listing-footer-wrapper">
            <div class="listing-locate" title="<?php echo clean($property->city_name); ?>">
                <span class="listing-location"><i class="ti-location-pin"></i><?php echo clean($property->city_name); ?></span>
            </div>
            <div class="listing-detail-btn">
                <a href="<?php echo e($property->url); ?>" class="more-btn"><?php echo e(__('View')); ?></a>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\sukna\platform/themes/resido/partials/real-estate/properties/item-list.blade.php ENDPATH**/ ?>