<?php if(is_plugin_active('newsletter')): ?>
<div class="footer-widget newsletter widget_newsletter">
    <div class="header-title-2">
        <h4 class="widget-title">
            <span><?php echo e($config['name']); ?></span>
        </h4>
        <?php if(!empty($config['subname'])): ?>
            <h3 class="font-heading"><?php echo e($config['subname']); ?></h3>
        <?php endif; ?>
    </div>
    <form class="form-subcriber newsletter-form mt-30" action="<?php echo e(route('public.newsletter.subscribe')); ?>" method="post">
        <?php echo csrf_field(); ?>
        <div class="form-group d-flex">
            <input type="email" name="email" class="form-control bg-white font-small" placeholder="<?php echo e(__('Enter your email')); ?>">
            <button class="btn bg-dark text-white" type="submit"><?php echo e(__('Subscribe')); ?></button>
        </div>
        <?php if(setting('enable_captcha') && is_plugin_active('captcha')): ?>
            <div class="form-group">
                <?php echo Captcha::display(); ?>

            </div>
        <?php endif; ?>
    </form>
</div>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\sukna\platform/themes/resido/////widgets/newsletter/templates/frontend.blade.php ENDPATH**/ ?>