<section id="pricing-section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7 col-md-10 text-center">
                <div class="sec-heading center">
                    <h2><?php echo clean($title); ?></h2>
                    <p><?php echo clean($description); ?></p>
                </div>
            </div>
        </div>

        <div class="row">

            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-4">
                    <div class="pricing-wrap <?php if($package->is_default): ?> platinum-pr recommended <?php else: ?> standard-pr <?php endif; ?>">
                        <div class="pricing-header">
                            <h4 class="pr-value">
                                <?php echo e(format_price($package->price, $package->currency, false, true)); ?>

                            </h4>
                            <h4 class="pr-title"><?php echo e($package->name); ?></h4>
                        </div>
                        <div class="pricing-body">
                            <ul>
                                <?php if($package->features): ?>
                                    <?php $__currentLoopData = json_decode($package->features, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count($feature) > 0): ?>
                                            <li class="available"><?php echo e(Arr::get($feature, '0.value')); ?></li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="pricing-bottom">
                            <a href="<?php echo e(route('public.account.package.subscribe', $package->id)); ?>"
                                class="btn-pricing"><?php echo e(__('Choose Plan')); ?></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\sukna\platform/themes/resido/partials/shortcodes/our-packages.blade.php ENDPATH**/ ?>